//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Reflection;

namespace LateBinding
{
	/// <summary>
	/// Podsumowanie dla LateBindingMain.
	/// </summary>
	class LateBindingMain
	{
		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			String progId = "COMTypes.TypeTest";
			Type t = Type.GetTypeFromProgID(progId);
			Object o = Activator.CreateInstance(t);

			t.InvokeMember("Name",
 				BindingFlags.SetProperty | 
				BindingFlags.Public | 
				BindingFlags.Instance, 
				null, o, new Object[] {"Testing"}, null, null, null);
			Object result = t.InvokeMember("Name",
				BindingFlags.GetProperty | 
				BindingFlags.Public | 
				BindingFlags.Instance, 
				null, o, null, null, null, null);
			Console.WriteLine("Nazwa: {0}", result);

			t.InvokeMember("Date",
				BindingFlags.SetProperty | 
				BindingFlags.Public | 
				BindingFlags.Instance, 
				null, o, new Object[] {DateTime.Now}, null, null, null);
			result = t.InvokeMember("Date",
				BindingFlags.GetProperty | 
				BindingFlags.Public | 
				BindingFlags.Instance, 
				null, o, null, null, null, null);
			Console.WriteLine("Data: {0}", result);
		}
	}
}
